/*
 * Decompiled with CFR 0.152.
 */
package com.ccc.barcode.internal;

import java.io.ByteArrayOutputStream;
import java.util.Optional;

public class FrameParser {
    private static byte startByte = (byte)2;
    private static byte stopByte = (byte)3;
    private State state = State.WAIT_ON_START;
    private ByteArrayOutputStream buffer = new ByteArrayOutputStream();

    public FrameParser() {
        this.buffer.reset();
    }

    public Optional<String> updateByte(byte input) {
        switch (this.state.ordinal()) {
            case 0: {
                if (input == startByte) {
                    this.state = State.READING;
                    return Optional.empty();
                }
                return Optional.empty();
            }
            case 1: {
                if (input == stopByte) {
                    this.state = State.WAIT_ON_START;
                    String messageContent = this.buffer.toString();
                    this.buffer.reset();
                    return Optional.of(messageContent);
                }
                this.buffer.write(input);
                return Optional.empty();
            }
        }
        throw new RuntimeException();
    }

    private static enum State {
        WAIT_ON_START,
        READING;

    }
}

