/*
 * Decompiled with CFR 0.152.
 */
package com.ccc.barcode.demo;

import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;

class PortVerifier
extends InputVerifier {
    private static final int MAX_PORT = 65535;
    private static final int MIN_PORT = 1;
    private static final int DEFAULT_PORT = 8080;

    PortVerifier() {
    }

    @Override
    public boolean shouldYieldFocus(JComponent input) {
        boolean isValid = this.verify(input);
        if (!isValid) {
            JFormattedTextField field = (JFormattedTextField)input;
            try {
                int portNumber = Integer.parseInt(field.getText());
                if (portNumber < 1) {
                    field.setText(String.valueOf(1));
                }
                if (portNumber > 65535) {
                    field.setText(String.valueOf(65535));
                }
            }
            catch (NumberFormatException e) {
                field.setText(String.valueOf(8080));
            }
        }
        return true;
    }

    @Override
    public boolean verify(JComponent input) {
        JFormattedTextField field = (JFormattedTextField)input;
        String text = field.getText();
        try {
            int portNumber = Integer.parseInt(text);
            return portNumber >= 1 && portNumber <= 65535;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

