/*
 * Decompiled with CFR 0.152.
 */
package com.ccc.barcode.demo;

import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;

class InetAddressVerifier
extends InputVerifier {
    InetAddressVerifier() {
    }

    @Override
    public boolean shouldYieldFocus(JComponent input) {
        boolean isValid = this.verify(input);
        if (!isValid) {
            JFormattedTextField field = (JFormattedTextField)input;
            field.setText(InetAddress.getLoopbackAddress().getHostAddress());
        }
        return true;
    }

    @Override
    public boolean verify(JComponent input) {
        JFormattedTextField field = (JFormattedTextField)input;
        String text = field.getText();
        try {
            InetAddress.getByName(text);
            return true;
        }
        catch (UnknownHostException e) {
            return false;
        }
    }
}

