/*
 * Decompiled with CFR 0.152.
 */
package com.ccc.barcode.demo;

import com.ccc.barcode.CameraInfo;
import com.ccc.barcode.CameraScanResult;
import com.ccc.barcode.CameraServer;
import com.ccc.barcode.demo.ConnectionList;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.imageio.ImageIO;

public class ConnectionListUpdateCameraServer
extends CameraServer {
    private ConnectionList connectionList;
    private Path targetDirectory = Files.createTempDirectory("barcode-sink", new FileAttribute[0]);

    public ConnectionListUpdateCameraServer(InetSocketAddress address, ConnectionList connectionList) throws IOException {
        super(address);
        this.connectionList = connectionList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path getTargetDirectory() {
        Path path = this.targetDirectory;
        synchronized (path) {
            return this.targetDirectory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTargetDirectory(Path path) {
        Path path2 = this.targetDirectory;
        synchronized (path2) {
            this.targetDirectory = path;
        }
    }

    @Override
    protected void onConnect(CameraInfo connection) {
        try {
            this.connectionList.addConnection(connection);
        }
        catch (IOException e) {
            System.out.println("Connection failed.");
        }
    }

    @Override
    protected void onDisconnect(CameraInfo connection) {
        try {
            this.connectionList.markDisconnected(connection);
        }
        catch (IOException e) {
            System.out.println("Failed to disconnect.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onMessage(CameraInfo connection, CameraScanResult result) {
        try {
            this.connectionList.incrementMessageCounter(connection);
            System.out.println(result.getBarcode());
            Path target = null;
            Path path = this.targetDirectory;
            synchronized (path) {
                target = Files.createTempFile(this.targetDirectory, null, ".bmp", new FileAttribute[0]);
            }
            String writerName = "BMP";
            boolean isWriter = ImageIO.write((RenderedImage)result.getImage(), writerName, target.toFile());
            if (!isWriter) {
                System.out.println("Could not use writer: " + writerName);
                return;
            }
            System.out.println("Saved image to file: " + String.valueOf(target));
        }
        catch (IOException e) {
            System.out.println("Could not print file: " + String.valueOf(e));
        }
    }
}

