/*
 * Decompiled with CFR 0.152.
 */
package com.ccc.barcode.demo;

import com.ccc.barcode.CameraInfo;
import com.ccc.barcode.demo.CameraInfoPanel;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.TitledBorder;

public class ConnectionList
extends JPanel {
    private ArrayList<InetSocketAddress> connections;
    private Map<InetSocketAddress, CameraInfoPanel> connectionToLabel;
    private Map<InetSocketAddress, Integer> messageCounters;
    private JPanel connectionsPanel = new JPanel();

    public void addConnection(CameraInfo connection) throws IOException {
        InetSocketAddress address = connection.getCameraAddress();
        this.connections.add(address);
        CameraInfoPanel panel = new CameraInfoPanel(connection);
        this.connectionToLabel.put(address, panel);
        this.messageCounters.put(address, 0);
        this.connectionsPanel.add(panel);
        panel.updateDisplay(true, connection, 0);
        panel.setVisible(true);
        this.revalidate();
    }

    public void clear() {
        for (CameraInfoPanel panel : this.connectionToLabel.values()) {
            this.connectionsPanel.remove(panel);
        }
        this.connections = new ArrayList();
        this.connectionToLabel = new HashMap<InetSocketAddress, CameraInfoPanel>();
        this.messageCounters = new HashMap<InetSocketAddress, Integer>();
        this.connectionsPanel.repaint();
    }

    public void incrementMessageCounter(CameraInfo connection) throws IOException {
        InetSocketAddress address = connection.getCameraAddress();
        int current = this.messageCounters.get(address);
        final CameraInfoPanel panel = this.connectionToLabel.get(address);
        this.messageCounters.put(address, current + 1);
        Color oldColor = panel.getBackground();
        panel.setBackground(Color.GREEN);
        Timer timer = new Timer(0, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        panel.setBackground(null);
                        ConnectionList.this.revalidate();
                    }
                });
            }
        });
        timer.setInitialDelay(500);
        timer.setRepeats(false);
        timer.start();
        panel.updateDisplay(true, connection, this.messageCounters.get(address));
        this.revalidate();
    }

    public void markDisconnected(CameraInfo connection) throws IOException {
        InetSocketAddress address = connection.getCameraAddress();
        CameraInfoPanel panel = this.connectionToLabel.get(address);
        panel.updateDisplay(false, connection, this.messageCounters.get(address));
        this.connectionToLabel.remove(address);
        this.messageCounters.remove(address);
        this.connectionsPanel.remove(panel);
        this.revalidate();
        this.repaint();
    }

    public ConnectionList() {
        this.connectionsPanel.setLayout(new BoxLayout(this.connectionsPanel, 1));
        JScrollPane connectionsScrollPanel = new JScrollPane(this.connectionsPanel, 22, 31);
        TitledBorder scrollPanelBorder = BorderFactory.createTitledBorder("Connection List");
        scrollPanelBorder.setTitleFont(new Font(this.getFont().getName(), 1, 38));
        connectionsScrollPanel.setBorder(scrollPanelBorder);
        this.add(connectionsScrollPanel);
        this.connections = new ArrayList();
        this.connectionToLabel = new HashMap<InetSocketAddress, CameraInfoPanel>();
        this.messageCounters = new HashMap<InetSocketAddress, Integer>();
        this.setLayout(new BoxLayout(this, 1));
        this.setVisible(true);
    }
}

