/*
 * Decompiled with CFR 0.152.
 */
package com.ccc.barcode.demo;

import com.ccc.barcode.demo.CameraServerConfigurationPanel;
import com.ccc.barcode.demo.CameraServerHandle;
import com.ccc.barcode.demo.ConnectionList;
import java.awt.Component;
import java.awt.GridLayout;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class CompatibilityDemo {
    public static void main(String[] args) {
        CompatibilityDemo.telemetryReport();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Path tempDirectory;
                JFrame frame = new JFrame("Compatibility Demo");
                frame.setDefaultCloseOperation(3);
                frame.setLayout(new GridLayout(1, 2));
                ConnectionList connectionList = new ConnectionList();
                try {
                    tempDirectory = Files.createTempDirectory("barcode-sink", new FileAttribute[0]);
                }
                catch (IOException e) {
                    System.out.println(e);
                    return;
                }
                CameraServerHandle cameraServerHandle = new CameraServerHandle(connectionList, tempDirectory);
                try {
                    cameraServerHandle.listen(new InetSocketAddress(InetAddress.getByName("0.0.0.0"), 8080));
                }
                catch (IOException e) {
                    System.out.println(e);
                }
                frame.add(new CameraServerConfigurationPanel(cameraServerHandle));
                frame.add((Component)connectionList, "West");
                frame.pack();
                frame.setExtendedState(6);
                frame.setVisible(true);
            }
        });
    }

    private static void telemetryReport() {
        HttpClient client = HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1).followRedirects(HttpClient.Redirect.NORMAL).connectTimeout(Duration.ofSeconds(20L)).build();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://climbing-computer-company.com/telemetry/demo-start")).timeout(Duration.ofMinutes(1L)).build();
        client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(HttpResponse::body);
    }
}

