/*
 * Decompiled with CFR 0.152.
 */
package com.ccc.barcode.demo;

import com.ccc.barcode.demo.ConnectionList;
import com.ccc.barcode.demo.ConnectionListUpdateCameraServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.file.Path;

public class CameraServerHandle {
    private ConnectionList connectionList;
    private ConnectionListUpdateCameraServer cameraServer;
    private Thread cameraThread;
    private Path targetDirectory;

    public CameraServerHandle(ConnectionList connectionList, Path targetDirectory) {
        this.connectionList = connectionList;
        this.targetDirectory = targetDirectory;
        this.cameraThread = new Thread();
    }

    public Path getTargetDirectory() {
        return this.cameraServer.getTargetDirectory();
    }

    public void setTargetDirectory(Path path) {
        this.targetDirectory = path;
        this.cameraServer.setTargetDirectory(path);
    }

    public void listen(InetSocketAddress address) throws IOException {
        this.cameraThread.interrupt();
        try {
            this.cameraThread.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        this.connectionList.clear();
        this.cameraServer = new ConnectionListUpdateCameraServer(address, this.connectionList);
        this.cameraServer.setTargetDirectory(this.targetDirectory);
        this.cameraThread = new Thread(this.cameraServer);
        this.cameraThread.start();
    }
}

