/*
 * Decompiled with CFR 0.152.
 */
package com.ccc.barcode.demo;

import com.ccc.barcode.demo.CameraServerHandle;
import com.ccc.barcode.demo.InetAddressVerifier;
import com.ccc.barcode.demo.PortVerifier;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class CameraServerConfigurationPanel
extends JPanel {
    private CameraServerHandle cameraHandle;

    public CameraServerConfigurationPanel(final CameraServerHandle cameraHandle) {
        this.cameraHandle = cameraHandle;
        this.setLayout(new BoxLayout(this, 1));
        JLabel instructions = new JLabel("<html>While this tool runs, supported cameras will attempt to connect. When you scan a barcode, you'll see a response.<br><br>This demo program uses the same code as the BarcodeSink library. If this demo works; the library will work!</html>");
        TitledBorder instructionsBorder = BorderFactory.createTitledBorder("Welcome!");
        instructionsBorder.setTitleFont(new Font(this.getFont().getName(), 1, 38));
        instructions.setBorder(instructionsBorder);
        instructions.setFont(new Font(this.getFont().getName(), 0, 36));
        this.add(instructions);
        JLabel trouble = new JLabel("<html>If you don't see any connections, check the following.<br><ol><li>Are the cameras fully plugged in?</li><li>If you're using a Cognex camera, is the camera configured in client mode? If not, it's a quick fix. Follow the official <a href=\"https://community.cognex.com/support/s/article/how-to-connect-to-a-tcp-ip-server-from-a-dataman-reader\">cognex documentation</a>.</li></ol></html>");
        trouble.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (!Desktop.isDesktopSupported()) {
                    return;
                }
                Desktop desktop = Desktop.getDesktop();
                if (!desktop.isSupported(Desktop.Action.BROWSE)) {
                    return;
                }
                try {
                    desktop.browse(new URI("https://community.cognex.com/support/s/article/how-to-connect-to-a-tcp-ip-server-from-a-dataman-reader"));
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        trouble.setCursor(new Cursor(12));
        TitledBorder troubleBorder = BorderFactory.createTitledBorder("Troubleshooting");
        troubleBorder.setTitleFont(new Font(this.getFont().getName(), 1, 38));
        trouble.setBorder(troubleBorder);
        trouble.setFont(new Font(this.getFont().getName(), 0, 36));
        this.add(trouble);
        JPanel netConfig = new JPanel();
        TitledBorder netConfigBorder = BorderFactory.createTitledBorder("Network Config");
        netConfigBorder.setTitleFont(new Font(this.getFont().getName(), 1, 38));
        netConfig.setBorder(netConfigBorder);
        netConfig.setLayout(new BoxLayout(netConfig, 1));
        JLabel netConfigLabel = new JLabel("<html>You can control the network settings of the camera server here.</html>");
        netConfigLabel.setFont(new Font(this.getFont().getName(), 0, 36));
        netConfig.add(netConfigLabel);
        NumberFormat portFieldFormat = NumberFormat.getNumberInstance();
        portFieldFormat.setParseIntegerOnly(true);
        JPanel portPanel = new JPanel();
        JLabel portLabel = new JLabel("Port:");
        portLabel.setFont(new Font(this.getFont().getName(), 0, 36));
        final JFormattedTextField portField = new JFormattedTextField();
        portField.setInputVerifier(new PortVerifier());
        portPanel.setLayout(new BoxLayout(portPanel, 1));
        portPanel.add(portLabel);
        portPanel.add(portField);
        portField.setFont(new Font(this.getFont().getName(), 0, 24));
        portField.setValue("8080");
        netConfig.add(portPanel);
        JPanel hostPanel = new JPanel();
        JLabel hostLabel = new JLabel("Host:");
        hostLabel.setFont(new Font(this.getFont().getName(), 0, 36));
        final JFormattedTextField hostField = new JFormattedTextField();
        hostField.setInputVerifier(new InetAddressVerifier());
        hostField.setFocusLostBehavior(1);
        hostPanel.setLayout(new BoxLayout(hostPanel, 1));
        hostPanel.add(hostLabel);
        hostPanel.add(hostField);
        hostField.setFont(new Font(this.getFont().getName(), 0, 24));
        hostField.setValue(InetAddress.getLoopbackAddress().getHostAddress());
        netConfig.add(hostPanel);
        JButton netRestartButton = new JButton("Restart Server");
        netRestartButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    cameraHandle.listen(new InetSocketAddress(InetAddress.getByName(hostField.getText()), Integer.parseInt(portField.getText())));
                }
                catch (UnknownHostException e) {
                    throw new RuntimeException(e);
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException(e);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        netConfig.add(netRestartButton);
        this.add(netConfig);
        JPanel imageDataConfig = new JPanel();
        TitledBorder imageDataConfigBorder = BorderFactory.createTitledBorder("Image Folder");
        imageDataConfig.setBorder(imageDataConfigBorder);
        imageDataConfigBorder.setTitleFont(new Font(this.getFont().getName(), 1, 38));
        imageDataConfig.setLayout(new BoxLayout(imageDataConfig, 1));
        JLabel imageDataLabel = new JLabel("<html>You can control where scan images are saved here.</html>");
        imageDataLabel.setFont(new Font(this.getFont().getName(), 0, 36));
        imageDataConfig.add(imageDataLabel);
        final JButton imageDataDestinationButton = new JButton(cameraHandle.getTargetDirectory().toString());
        imageDataDestinationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JFileChooser fileChooser = new JFileChooser();
                fileChooser.setFileSelectionMode(2);
                int result = fileChooser.showOpenDialog(null);
                if (result == 0) {
                    cameraHandle.setTargetDirectory(fileChooser.getSelectedFile().toPath());
                    imageDataDestinationButton.setText(cameraHandle.getTargetDirectory().toString());
                }
            }
        });
        imageDataConfig.add(imageDataDestinationButton);
        this.add(imageDataConfig);
    }
}

