/*
 * Decompiled with CFR 0.152.
 */
package com.ccc.barcode.demo;

import com.ccc.barcode.CameraInfo;
import java.awt.Dimension;
import java.awt.Font;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CameraInfoPanel
extends JPanel {
    private CameraInfo cameraConnection;
    private JLabel networkLabel;
    private JLabel statusLabel;
    private JLabel countLabel;

    public CameraInfoPanel(CameraInfo cameraConnection) {
        this.cameraConnection = cameraConnection;
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, 100));
        this.setMinimumSize(new Dimension(0, 100));
        this.statusLabel = new JLabel("[LOADING]", 2);
        this.statusLabel.setFont(new Font(this.getFont().getName(), 1, 24));
        this.networkLabel = new JLabel("[LOADING]", 4);
        this.networkLabel.setFont(new Font(this.getFont().getName(), 0, 24));
        this.countLabel = new JLabel("[LOADING]", 4);
        this.countLabel.setFont(new Font(this.getFont().getName(), 0, 24));
        this.setBorder(BorderFactory.createBevelBorder(0));
        this.add(this.statusLabel);
        this.add(this.networkLabel);
        this.add(this.countLabel);
    }

    public void updateDisplay(boolean connectionStatus, CameraInfo connection, int messageCount) {
        try {
            this.statusLabel.setText("Connected:");
            String networkText = String.valueOf(connection.getCameraAddress().getAddress()) + ":" + Integer.toString(connection.getCameraAddress().getPort());
            this.networkLabel.setText(networkText);
            this.countLabel.setText(": Barcode Count: " + Integer.toString(messageCount));
        }
        catch (ClosedChannelException e) {
            this.statusLabel.setText("Disconnected:");
        }
        catch (IOException e) {
            this.statusLabel.setText("Disconnected:");
        }
    }
}

