/*
 * Decompiled with CFR 0.152.
 */
package com.ccc.barcode;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.charset.StandardCharsets;

public class FakeCameraClient
implements AutoCloseable {
    public final InetAddress address;
    private ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private Socket socket;

    FakeCameraClient(InetAddress address, int port) throws IOException {
        this.address = address;
        this.socket = new Socket(address, port);
    }

    private void buildMessage(String body) {
        this.buffer.write(2);
        for (byte input : body.getBytes(StandardCharsets.US_ASCII)) {
            this.buffer.write(input);
        }
        this.buffer.write(3);
    }

    public void send(String message) throws IOException {
        this.buffer.reset();
        this.buildMessage(message);
        this.buffer.writeTo(this.socket.getOutputStream());
    }

    @Override
    public void close() throws IOException {
        this.socket.close();
    }
}

