/*
 * Decompiled with CFR 0.152.
 */
package com.ccc.barcode;

import com.ccc.barcode.CameraConnection;
import com.ccc.barcode.CameraInfo;
import com.ccc.barcode.CameraScanResult;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import jdk.net.ExtendedSocketOptions;

public class CameraServer
implements Runnable {
    public final SocketAddress address;
    private Map<SelectionKey, CameraConnection> connectionTable = new HashMap<SelectionKey, CameraConnection>();

    public CameraServer(InetSocketAddress address) {
        this.address = address;
    }

    protected void onConnect(CameraInfo connection) {
        System.out.println("Connected");
    }

    protected void onDisconnect(CameraInfo connection) {
        System.out.println("Disconnected");
    }

    protected void onMessage(CameraInfo connection, CameraScanResult result) {
        System.out.println("Message: " + result.getBarcode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Selector selector = Selector.open();
            ServerSocketChannel server = ServerSocketChannel.open();
            try {
                server.bind(this.address);
                server.configureBlocking(false);
                server.register(selector, 16, null);
                server.configureBlocking(false);
                while (!Thread.currentThread().isInterrupted()) {
                    selector.select();
                    Set<SelectionKey> selectedKeys = selector.selectedKeys();
                    Iterator<SelectionKey> iter = selectedKeys.iterator();
                    while (iter.hasNext()) {
                        CameraConnection connection;
                        SelectionKey key = iter.next();
                        if (key.isAcceptable()) {
                            SocketChannel client = server.accept();
                            client.configureBlocking(false);
                            client.setOption((SocketOption)StandardSocketOptions.SO_KEEPALIVE, (Object)true);
                            client.setOption((SocketOption)ExtendedSocketOptions.TCP_KEEPIDLE, (Object)10);
                            client.setOption((SocketOption)ExtendedSocketOptions.TCP_KEEPCOUNT, (Object)2);
                            client.setOption((SocketOption)ExtendedSocketOptions.TCP_KEEPINTERVAL, (Object)3);
                            SelectionKey newClientKey = client.register(selector, 1);
                            CameraConnection newCameraConnection = new CameraConnection(client);
                            this.connectionTable.put(newClientKey, newCameraConnection);
                            this.onConnect(new CameraInfo(newCameraConnection));
                            iter.remove();
                            continue;
                        }
                        if (key.isReadable()) {
                            connection = this.connectionTable.get(key);
                            if (!this.connectionTable.get(key).onRead()) {
                                this.onDisconnect(new CameraInfo(connection));
                                key.cancel();
                            } else {
                                Optional<CameraScanResult> scanResult = connection.getMessage();
                                if (scanResult.isPresent()) {
                                    this.onMessage(new CameraInfo(connection), scanResult.get());
                                }
                                key.interestOps(connection.currentInterest());
                            }
                            iter.remove();
                            continue;
                        }
                        if (!key.isWritable()) continue;
                        connection = this.connectionTable.get(key);
                        connection.onWrite();
                        key.interestOps(connection.currentInterest());
                        iter.remove();
                    }
                }
            }
            finally {
                server.close();
                selector.close();
            }
        }
        catch (ClosedByInterruptException e) {
            System.out.println(e);
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }
}

