/*
 * Decompiled with CFR 0.152.
 */
package com.ccc.barcode;

import com.ccc.barcode.CameraScanResult;
import com.ccc.barcode.internal.LineParser;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import javax.imageio.ImageIO;

public class CameraConnection {
    private SocketChannel connection;
    private LineParser barcodeParser = new LineParser();
    private LineParser imageSizeParser = new LineParser();
    private int messageCount = 0;
    private String currentBarcode;
    private int currentImageSize;
    private int currentImageReadCount;
    private ByteArrayOutputStream currentImageStream = new ByteArrayOutputStream();
    private boolean isReady = false;
    State state;

    public CameraConnection(SocketChannel connection) {
        this.connection = connection;
        this.state = State.READING_BARCODE;
    }

    public int currentInterest() {
        switch (this.state.ordinal()) {
            case 0: 
            case 2: 
            case 3: {
                return 1;
            }
            case 1: {
                return 4;
            }
            case 4: {
                return 0;
            }
        }
        throw new RuntimeException("Invalid state.");
    }

    public void onWrite() throws IOException {
        switch (this.state.ordinal()) {
            case 1: {
                this.connection.write(ByteBuffer.wrap("||>IMAGE.SEND\r\n".getBytes(StandardCharsets.UTF_8)));
                this.state = State.READING_IMAGE_SIZE;
                break;
            }
            default: {
                throw new RuntimeException("Bad state for writing.");
            }
        }
    }

    public boolean onRead() throws IOException {
        int bytes_read = 0;
        switch (this.state.ordinal()) {
            case 0: {
                ByteBuffer byteBuffer = ByteBuffer.allocate(1);
                bytes_read = this.connection.read(byteBuffer);
                if (bytes_read == -1) {
                    return false;
                }
                byteBuffer.flip();
                while (byteBuffer.hasRemaining()) {
                    Optional<String> result = this.barcodeParser.updateByte(byteBuffer.get());
                    if (!result.isPresent()) continue;
                    this.currentBarcode = result.get();
                    this.state = State.WRITING_IMAGE_REQUEST;
                }
                return true;
            }
            case 2: {
                ByteBuffer byteBuffer = ByteBuffer.allocate(1);
                bytes_read = this.connection.read(byteBuffer);
                if (bytes_read == -1) {
                    return false;
                }
                byteBuffer.flip();
                while (byteBuffer.hasRemaining()) {
                    Optional<String> result = this.imageSizeParser.updateByte(byteBuffer.get());
                    if (!result.isPresent()) continue;
                    this.currentImageSize = Integer.parseInt(result.get());
                    this.currentImageReadCount = 0;
                    this.state = State.READING_IMAGE;
                }
                return true;
            }
            case 3: {
                ByteBuffer byteBuffer = ByteBuffer.allocate(this.currentImageSize - this.currentImageReadCount);
                bytes_read = this.connection.read(byteBuffer);
                if (bytes_read == -1) {
                    return false;
                }
                byteBuffer.flip();
                while (byteBuffer.hasRemaining() && this.currentImageReadCount < this.currentImageSize) {
                    this.currentImageStream.write(byteBuffer.get());
                    ++this.currentImageReadCount;
                }
                System.out.println(this.currentImageReadCount);
                if (this.currentImageSize == this.currentImageReadCount) {
                    this.state = State.COMPLETE;
                    this.isReady = true;
                    this.barcodeParser = new LineParser();
                    this.imageSizeParser = new LineParser();
                }
                return true;
            }
        }
        throw new RuntimeException("Bad state for reading.");
    }

    public Optional<CameraScanResult> getMessage() {
        if (!this.isReady) {
            return Optional.empty();
        }
        this.isReady = false;
        this.state = State.READING_BARCODE;
        try {
            BufferedImage bufferedImageStream = ImageIO.read(new ByteArrayInputStream(this.currentImageStream.toByteArray()));
            return Optional.of(new CameraScanResult(this.currentBarcode, bufferedImageStream));
        }
        catch (IOException e) {
            System.out.println("Invalid image read in.");
            return Optional.empty();
        }
    }

    public SocketChannel getSocketChannel() {
        return this.connection;
    }

    private static enum State {
        READING_BARCODE,
        WRITING_IMAGE_REQUEST,
        READING_IMAGE_SIZE,
        READING_IMAGE,
        COMPLETE;

    }
}

